/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.GridLookPainter;
import net.sf.paperclips.GridMargins;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public abstract class BasicGridLookPainter
implements GridLookPainter {
    protected final Device device;

    public BasicGridLookPainter(Device device) {
        Util.notNull(device);
        this.device = device;
    }

    public void paint(GC gc, int x, int y, int[] columns, int[] headerRows, int[][] headerColSpans, int firstRowIndex, boolean topOpen, int[] bodyRows, int[][] bodyColSpans, boolean bottomOpen, int[] footerRows, int[][] footerColSpans) {
        GridMargins margins = this.getMargins();
        boolean headerPresent = headerRows.length > 0;
        boolean footerPresent = footerRows.length > 0;
        x += margins.getLeft();
        if (headerPresent) {
            y = this.paintHeader(gc, x, y, columns, headerRows, headerColSpans);
        }
        y += margins.getBodyTop(headerPresent, topOpen);
        y = this.paintBody(gc, x, y, columns, bodyRows, bodyColSpans, firstRowIndex, topOpen, bottomOpen);
        y += margins.getBodyBottom(footerPresent, bottomOpen);
        if (footerPresent) {
            this.paintFooter(gc, x, y, columns, footerRows, footerColSpans);
        }
    }

    private int paintHeader(GC gc, int x, int y, int[] columns, int[] rows, int[][] colSpans) {
        GridMargins margins = this.getMargins();
        y += margins.getHeaderTop();
        int i = 0;
        while (i < rows.length) {
            int h = rows[i];
            this.paintHeaderRow(gc, x, y, columns, h, i, colSpans[i]);
            y += h;
            if (i < rows.length - 1) {
                y += margins.getHeaderVerticalSpacing();
            }
            ++i;
        }
        return y;
    }

    private int paintBody(GC gc, int x, int y, int[] columns, int[] rows, int[][] colSpans, int firstRowIndex, boolean topOpen, boolean bottomOpen) {
        GridMargins margins = this.getMargins();
        int i = 0;
        while (i < rows.length) {
            int h = rows[i];
            this.paintBodyRow(gc, x, y, columns, h, colSpans[i], firstRowIndex + i, i == 0 && topOpen, i == rows.length - 1 && bottomOpen);
            y += h;
            if (i < rows.length - 1) {
                y += margins.getBodyVerticalSpacing();
            }
            ++i;
        }
        return y;
    }

    private void paintFooter(GC gc, int x, int y, int[] columns, int[] rows, int[][] colSpans) {
        GridMargins margins = this.getMargins();
        int i = 0;
        while (i < rows.length) {
            int h = rows[i];
            this.paintFooterRow(gc, x, y, columns, h, i, colSpans[i]);
            y += h;
            y += margins.getFooterVerticalSpacing();
            ++i;
        }
    }

    private void paintHeaderRow(GC gc, int x, int y, int[] columns, int h, int rowIndex, int[] colSpans) {
        GridMargins margins = this.getMargins();
        int col = 0;
        int i = 0;
        while (i < colSpans.length) {
            int colSpan = colSpans[i];
            int w = this.sum(columns, col, colSpan) + (colSpan - 1) * margins.getHorizontalSpacing();
            this.paintHeaderCell(gc, new Rectangle(x, y, w, h), rowIndex, col, colSpan);
            col += colSpan;
            x += w + margins.getHorizontalSpacing();
            ++i;
        }
    }

    private void paintBodyRow(GC gc, int x, int y, int[] columns, int h, int[] colSpans, int rowIndex, boolean topOpen, boolean bottomOpen) {
        GridMargins margins = this.getMargins();
        int col = 0;
        int i = 0;
        while (i < colSpans.length) {
            int colSpan = colSpans[i];
            int w = this.sum(columns, col, colSpan) + (colSpan - 1) * margins.getHorizontalSpacing();
            this.paintBodyCell(gc, new Rectangle(x, y, w, h), rowIndex, col, colSpan, topOpen, bottomOpen);
            col += colSpan;
            x += w + margins.getHorizontalSpacing();
            ++i;
        }
    }

    private void paintFooterRow(GC gc, int x, int y, int[] columns, int h, int rowIndex, int[] colSpans) {
        GridMargins margins = this.getMargins();
        int col = 0;
        int i = 0;
        while (i < colSpans.length) {
            int colSpan = colSpans[i];
            int w = this.sum(columns, col, colSpan) + (colSpan - 1) * margins.getHorizontalSpacing();
            this.paintFooterCell(gc, new Rectangle(x, y, w, h), rowIndex, col, colSpan);
            col += colSpan;
            x += w + margins.getHorizontalSpacing();
            ++i;
        }
    }

    private int sum(int[] elements, int start, int length) {
        int sum = 0;
        int j = 0;
        while (j < length) {
            sum += elements[start + j];
            ++j;
        }
        return sum;
    }

    protected abstract void paintHeaderCell(GC var1, Rectangle var2, int var3, int var4, int var5);

    protected abstract void paintBodyCell(GC var1, Rectangle var2, int var3, int var4, int var5, boolean var6, boolean var7);

    protected abstract void paintFooterCell(GC var1, Rectangle var2, int var3, int var4, int var5);
}

