/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class ComboDrawData
extends DrawData {
    public ComboDrawData() {
        this.state = new int[2];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, EDIT);
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rectangle.y + rectangle.height;
            int[] nArray = this.getPartId(0);
            OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            RECT rECT2 = new RECT();
            OS.GetThemeBackgroundContentRect(l, gC.handle, nArray[0], nArray[1], rECT, rECT2);
            Rectangle rectangle2 = this.clientArea;
            if (rectangle2 != null) {
                rectangle2.x = rECT2.left;
                rectangle2.y = rECT2.top;
                rectangle2.width = rECT2.right - rECT2.left;
                rectangle2.height = rECT2.bottom - rECT2.top;
            }
            OS.CloseThemeData(l);
            l = OS.OpenThemeData(0L, this.getClassId());
            int n = OS.GetThemeSysSize(l, 2);
            rECT.left = rECT2.right - n;
            rECT.top = rECT2.top;
            rECT.right = rECT2.right;
            rECT.bottom = rECT2.bottom;
            nArray = this.getPartId(1);
            OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            OS.CloseThemeData(l);
            if (rectangle2 != null) {
                rectangle2.width -= n;
            }
        }
    }

    char[] getClassId() {
        return COMBOBOX;
    }

    int[] getPartId(int n) {
        int n2 = this.state[n];
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n3 = 1;
                n4 = 1;
                if ((n2 & 0x20) == 0) break;
                n4 = 4;
                break;
            }
            case 1: {
                n3 = 1;
                n4 = 1;
                if ((n2 & 0x20) != 0) {
                    n4 = 4;
                }
                if ((n2 & 0x40) != 0) {
                    n4 = 2;
                }
                if ((n2 & 8) == 0) break;
                n4 = 3;
            }
        }
        return new int[]{n3, n4};
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return -1;
        }
        if (!rectangle.contains(point)) {
            return -1;
        }
        long l = OS.OpenThemeData(0L, EDIT);
        int[] nArray = this.getPartId(0);
        int n = nArray[0];
        int n2 = nArray[1];
        RECT rECT = new RECT();
        rECT.left = rectangle.x;
        rECT.right = rectangle.x + rectangle.width;
        rECT.top = rectangle.y;
        rECT.bottom = rectangle.y + rectangle.height;
        RECT rECT2 = new RECT();
        OS.GetThemeBackgroundContentRect(l, 0L, n, n2, rECT, rECT2);
        OS.CloseThemeData(l);
        l = OS.OpenThemeData(0L, this.getClassId());
        int n3 = OS.GetThemeSysSize(l, 2);
        OS.CloseThemeData(l);
        Rectangle rectangle2 = new Rectangle(rECT2.right - n3, rECT2.top, rECT2.bottom - rECT2.top, n3);
        if (rectangle2.contains(point)) {
            return 1;
        }
        return 0;
    }
}

