/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    int itemCount;
    ExpandItem focusItem;
    int spacing = 4;
    int yCurrentScroll;
    long hFont;

    public ExpandBar(Composite composite, int n) {
        super(composite, ExpandBar.checkStyle(n));
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.DefWindowProc(l, n, l2, l3);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        return (n &= 0xFFFFFEFF) | 0x40000;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((n == -1 || n2 == -1) && this.itemCount > 0) {
            Object object;
            long l = OS.GetDC(this.handle);
            long l2 = 0L;
            if (this.isAppThemed()) {
                l2 = this.display.hExplorerBarTheme();
            }
            long l3 = 0L;
            long l4 = 0L;
            if (l2 == 0L) {
                if (this.hFont != 0L) {
                    l3 = this.hFont;
                } else if (!OS.IsWinCE) {
                    NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
                    nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
                    if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                        object = OS.IsUnicode ? nONCLIENTMETRICS.lfCaptionFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfCaptionFont;
                        l3 = OS.CreateFontIndirect((LOGFONT)object);
                    }
                }
                if (l3 != 0L) {
                    l4 = OS.SelectObject(l, l3);
                }
            }
            n3 += this.spacing;
            int n5 = 0;
            while (n5 < this.itemCount) {
                object = this.items[n5];
                n3 += ((ExpandItem)object).getHeaderHeight();
                if (((ExpandItem)object).expanded) {
                    n3 += ((ExpandItem)object).height;
                }
                n3 += this.spacing;
                n4 = Math.max(n4, ((ExpandItem)object).getPreferredWidth(l2, l));
                ++n5;
            }
            if (l3 != 0L) {
                OS.SelectObject(l, l4);
                if (l3 != this.hFont) {
                    OS.DeleteObject(l3);
                }
            }
            OS.ReleaseDC(this.handle, l);
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n4, n3);
        return new Point(rectangle.width, rectangle.height);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        this.state |= 0x2000;
    }

    void createItem(ExpandItem expandItem, int n, int n2) {
        Object object;
        if (n2 < 0 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            object = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = expandItem;
        ++this.itemCount;
        if (this.focusItem == null) {
            this.focusItem = expandItem;
        }
        object = new RECT();
        OS.GetWindowRect(this.handle, (RECT)object);
        expandItem.width = Math.max(0, object.right - object.left - this.spacing * 2);
        this.layoutItems(n2, true);
    }

    void createWidget() {
        super.createWidget();
        this.items = new ExpandItem[4];
        if (!this.isAppThemed()) {
            this.backgroundMode = 1;
        }
    }

    int defaultBackground() {
        if (!this.isAppThemed()) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return super.defaultBackground();
    }

    void destroyItem(ExpandItem expandItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == expandItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        if (expandItem == this.focusItem) {
            int n2;
            int n3 = n2 = n > 0 ? n - 1 : 1;
            if (n2 < this.itemCount) {
                this.focusItem = this.items[n2];
                this.focusItem.redraw(true);
            } else {
                this.focusItem = null;
            }
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        expandItem.redraw(true);
        this.layoutItems(n, true);
    }

    void drawThemeBackground(long l, long l2, RECT rECT) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        OS.MapWindowPoints(this.handle, l2, rECT2, 2);
        OS.DrawThemeBackground(this.display.hExplorerBarTheme(), l, 5, 0, rECT2, null);
    }

    void drawWidget(GC gC, RECT rECT) {
        Object object;
        long l = 0L;
        if (this.isAppThemed()) {
            l = this.display.hExplorerBarTheme();
        }
        if (l != 0L) {
            RECT rECT2 = new RECT();
            OS.GetClientRect(this.handle, rECT2);
            OS.DrawThemeBackground(l, gC.handle, 1, 0, rECT2, rECT);
        } else {
            this.drawBackground(gC.handle);
        }
        boolean bl = false;
        if (this.handle == OS.GetFocus()) {
            int n = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
            bl = (n & 1) == 0;
        }
        long l2 = 0L;
        long l3 = 0L;
        if (l == 0L) {
            if (this.hFont != 0L) {
                l2 = this.hFont;
            } else if (!OS.IsWinCE) {
                NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
                nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
                if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                    object = OS.IsUnicode ? nONCLIENTMETRICS.lfCaptionFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfCaptionFont;
                    l2 = OS.CreateFontIndirect((LOGFONT)object);
                }
            }
            if (l2 != 0L) {
                l3 = OS.SelectObject(gC.handle, l2);
            }
            if (this.foreground != -1) {
                OS.SetTextColor(gC.handle, this.foreground);
            }
        }
        int n = 0;
        while (n < this.itemCount) {
            ((ExpandItem)object).drawItem(gC, l, rECT, (object = this.items[n]) == this.focusItem && bl);
            ++n;
        }
        if (l2 != 0L) {
            OS.SelectObject(gC.handle, l3);
            if (l2 != this.hFont) {
                OS.DeleteObject(l2);
            }
        }
    }

    Control findBackgroundControl() {
        Control control = super.findBackgroundControl();
        if (!this.isAppThemed() && control == null) {
            control = this;
        }
        return control;
    }

    Control findThemeControl() {
        return this.isAppThemed() ? this : super.findThemeControl();
    }

    int getBandHeight() {
        if (this.hFont == 0L) {
            return 24;
        }
        long l = OS.GetDC(this.handle);
        long l2 = OS.SelectObject(l, this.hFont);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(l, tEXTMETRIC);
        OS.SelectObject(l, l2);
        OS.ReleaseDC(this.handle, l);
        return Math.max(24, tEXTMETRIC.tmHeight + 4);
    }

    public ExpandItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == expandItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean isAppThemed() {
        if (this.background != -1) {
            return false;
        }
        if (this.foreground != -1) {
            return false;
        }
        if (this.hFont != 0L) {
            return false;
        }
        return OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed();
    }

    void layoutItems(int n, boolean bl) {
        if (n < this.itemCount) {
            ExpandItem expandItem;
            int n2 = this.spacing - this.yCurrentScroll;
            int n3 = 0;
            while (n3 < n) {
                expandItem = this.items[n3];
                if (expandItem.expanded) {
                    n2 += expandItem.height;
                }
                n2 += expandItem.getHeaderHeight() + this.spacing;
                ++n3;
            }
            n3 = n;
            while (n3 < this.itemCount) {
                expandItem = this.items[n3];
                expandItem.setBounds(this.spacing, n2, 0, 0, true, false);
                if (expandItem.expanded) {
                    n2 += expandItem.height;
                }
                n2 += expandItem.getHeaderHeight() + this.spacing;
                ++n3;
            }
        }
        if (bl) {
            this.setScrollbar();
        }
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                ExpandItem expandItem = this.items[n];
                if (expandItem != null && !expandItem.isDisposed()) {
                    expandItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        this.focusItem = null;
        super.releaseChildren(bl);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                ExpandItem expandItem = this.items[n2];
                if (expandItem != null) {
                    expandItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        if (!OS.IsWinCE) {
            int n2 = 1157;
            OS.RedrawWindow(this.handle, null, 0L, n2);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.hFont = font != null ? font.handle : 0L;
        this.layoutItems(0, true);
    }

    void setForegroundPixel(int n) {
        super.setForegroundPixel(n);
        if (!OS.IsWinCE) {
            int n2 = 1157;
            OS.RedrawWindow(this.handle, null, 0L, n2);
        }
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n = rECT.bottom - rECT.top;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n2 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n2 += expandItem.height;
        }
        if (this.yCurrentScroll > 0 && n > n2) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n2 - n);
            this.layoutItems(0, false);
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 7;
        sCROLLINFO.nMin = 0;
        sCROLLINFO.nMax = n2 += this.yCurrentScroll;
        sCROLLINFO.nPage = n;
        sCROLLINFO.nPos = Math.min(this.yCurrentScroll, sCROLLINFO.nMax);
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        OS.SetScrollInfo(this.handle, 1, sCROLLINFO, true);
    }

    public void setSpacing(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.spacing) {
            return;
        }
        this.spacing = n;
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n2 = Math.max(0, rECT.right - rECT.left - n * 2);
        int n3 = 0;
        while (n3 < this.itemCount) {
            ExpandItem expandItem = this.items[n3];
            if (expandItem.width != n2) {
                expandItem.setBounds(0, 0, n2, expandItem.height, false, true);
            }
            ++n3;
        }
        this.layoutItems(0, true);
        OS.InvalidateRect(this.handle, null, true);
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw(true);
        int n = this.indexOf(expandItem);
        this.layoutItems(n + 1, true);
    }

    void showFocus(boolean bl) {
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n = rECT.bottom - rECT.top;
        int n2 = 0;
        if (bl) {
            if (this.focusItem.y < 0) {
                n2 = Math.min(this.yCurrentScroll, -this.focusItem.y);
            }
        } else {
            int n3 = this.focusItem.y + this.getBandHeight();
            if (this.focusItem.expanded && n >= this.getBandHeight() + this.focusItem.height) {
                n3 += this.focusItem.height;
            }
            if (n3 > n) {
                n2 = n - n3;
            }
        }
        if (n2 != 0) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll - n2);
            if ((this.style & 0x200) != 0) {
                SCROLLINFO sCROLLINFO = new SCROLLINFO();
                sCROLLINFO.cbSize = SCROLLINFO.sizeof;
                sCROLLINFO.fMask = 4;
                sCROLLINFO.nPos = this.yCurrentScroll;
                OS.SetScrollInfo(this.handle, 1, sCROLLINFO, true);
            }
            OS.ScrollWindowEx(this.handle, 0, n2, null, null, 0L, null, 3);
            int n4 = 0;
            while (n4 < this.itemCount) {
                this.items[n4].y += n2;
                ++n4;
            }
        }
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    long windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_KEYDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.focusItem == null) {
            return lRESULT;
        }
        switch ((int)l) {
            case 13: 
            case 32: {
                Event event = new Event();
                event.item = this.focusItem;
                this.sendEvent(this.focusItem.expanded ? 18 : 17, event);
                this.focusItem.expanded = !this.focusItem.expanded;
                this.showItem(this.focusItem);
                return LRESULT.ZERO;
            }
            case 38: {
                int n = this.indexOf(this.focusItem);
                if (n <= 0) break;
                this.focusItem.redraw(true);
                this.focusItem = this.items[n - 1];
                this.focusItem.redraw(true);
                this.showFocus(true);
                return LRESULT.ZERO;
            }
            case 40: {
                int n = this.indexOf(this.focusItem);
                if (n >= this.itemCount - 1) break;
                this.focusItem.redraw(true);
                this.focusItem = this.items[n + 1];
                this.focusItem.redraw(true);
                this.showFocus(false);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(l, l2);
        if (this.focusItem != null) {
            this.focusItem.redraw(true);
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        int n = OS.GET_X_LPARAM(l2);
        int n2 = OS.GET_Y_LPARAM(l2);
        int n3 = 0;
        while (n3 < this.itemCount) {
            ExpandItem expandItem = this.items[n3];
            boolean bl = expandItem.isHover(n, n2);
            if (bl && this.focusItem != expandItem) {
                this.focusItem.redraw(true);
                this.focusItem = expandItem;
                this.focusItem.redraw(true);
                this.forceFocus();
                break;
            }
            ++n3;
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_LBUTTONUP(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (this.focusItem == null) {
            return lRESULT;
        }
        int n2 = OS.GET_X_LPARAM(l2);
        boolean bl = this.focusItem.isHover(n2, n = OS.GET_Y_LPARAM(l2));
        if (bl) {
            Event event = new Event();
            event.item = this.focusItem;
            this.sendEvent(this.focusItem.expanded ? 18 : 17, event);
            this.focusItem.expanded = !this.focusItem.expanded;
            this.showItem(this.focusItem);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSELEAVE(long l, long l2) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n = 0;
        while (n < this.itemCount) {
            ExpandItem expandItem = this.items[n];
            if (expandItem.hover) {
                expandItem.hover = false;
                expandItem.redraw(false);
                break;
            }
            ++n;
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(long l, long l2) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        int n = OS.GET_X_LPARAM(l2);
        int n2 = OS.GET_Y_LPARAM(l2);
        int n3 = 0;
        while (n3 < this.itemCount) {
            ExpandItem expandItem = this.items[n3];
            boolean bl = expandItem.isHover(n, n2);
            if (expandItem.hover != bl) {
                expandItem.hover = bl;
                expandItem.redraw(false);
            }
            ++n3;
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEWHEEL(long l, long l2) {
        return this.wmScrollWheel(true, l, l2);
    }

    LRESULT WM_PAINT(long l, long l2) {
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = pAINTSTRUCT;
        gCData.hwnd = this.handle;
        GC gC = this.new_GC(gCData);
        if (gC != null) {
            int n = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n2 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n != 0 && n2 != 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawWidget(gC, rECT);
                if (this.hooks(9) || this.filters(9)) {
                    Event event = new Event();
                    event.gc = gC;
                    event.x = rECT.left;
                    event.y = rECT.top;
                    event.width = n;
                    event.height = n2;
                    this.sendEvent(9, event);
                    event.gc = null;
                }
            }
            gC.dispose();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(long l, long l2) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(l, l2);
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.foreground = this.getForegroundPixel();
        GC gC = GC.win32_new(l, gCData);
        this.drawWidget(gC, rECT);
        gC.dispose();
        return lRESULT;
    }

    LRESULT WM_SETCURSOR(long l, long l2) {
        LRESULT lRESULT = super.WM_SETCURSOR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        short s = (short)OS.LOWORD(l2);
        if (s == 1) {
            int n = 0;
            while (n < this.itemCount) {
                ExpandItem expandItem = this.items[n];
                if (expandItem.hover) {
                    long l3 = OS.LoadCursor(0L, 32649L);
                    OS.SetCursor(l3);
                    return LRESULT.ONE;
                }
                ++n;
            }
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_SETFOCUS(l, l2);
        if (this.focusItem != null) {
            this.focusItem.redraw(true);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(long l, long l2) {
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n = Math.max(0, rECT.right - rECT.left - this.spacing * 2);
        int n2 = 0;
        while (n2 < this.itemCount) {
            ExpandItem expandItem = this.items[n2];
            if (expandItem.width != n) {
                expandItem.setBounds(0, 0, n, expandItem.height, false, true);
            }
            ++n2;
        }
        this.setScrollbar();
        OS.InvalidateRect(this.handle, null, true);
        return lRESULT;
    }

    LRESULT wmScroll(ScrollBar scrollBar, boolean bl, long l, int n, long l2, long l3) {
        LRESULT lRESULT = super.wmScroll(scrollBar, true, l, n, l2, l3);
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 4;
        OS.GetScrollInfo(this.handle, 1, sCROLLINFO);
        int n2 = this.yCurrentScroll - sCROLLINFO.nPos;
        OS.ScrollWindowEx(this.handle, 0, n2, null, null, 0L, null, 3);
        this.yCurrentScroll = sCROLLINFO.nPos;
        if (n2 != 0) {
            int n3 = 0;
            while (n3 < this.itemCount) {
                this.items[n3].y += n2;
                ++n3;
            }
        }
        return lRESULT;
    }
}

